using System;
using System.Configuration.Install;
using System.Globalization;
using System.Linq;
using System.Reflection;
using gov.va.med.vbecs.Common.Log;

namespace VBECS.Service
{
    /// <summary>
    /// SelfInstaller is a helper class for services.
    /// It provides easy way to install/uninstall windows services.
    /// </summary>
    public class SelfInstaller
    {
        readonly static ILogger Logger = LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);

		/// <summary>
		/// Installs service.
		/// </summary>
		/// <param name="assemblyLocation">
		/// Full file name for the service assembly
		/// </param>
		/// <param name="args">
		/// input installation arguments 
		/// </param>
        public static bool InstallMe(string assemblyLocation, string[] args)
        {
            try
            {
                Logger.Debug("Start installing assembly: " + assemblyLocation + Environment.NewLine + 
                    "Arguments: " + String.Join(",", (args ?? new string[0]).Select(p => p.ToString(CultureInfo.InvariantCulture)).ToArray()));
                ManagedInstallerClass.InstallHelper((args ?? new string[0]).Union(new[] { assemblyLocation }).ToArray());
                Logger.Debug("Assembly installed");
            }
            catch(Exception e)
            {
                Logger.Error("Service installation failed. Exception: " + e);
                return false;
            }
            return true;
        }

		/// <summary>
		/// Uninstalls service.
		/// </summary>
		/// <param name="assemblyLocation">
		/// Full file name for the service assembly
		/// </param>
        public static bool UninstallMe(string assemblyLocation)
        {
            try
            {
                Logger.Debug("Start uninstalling assembly: " + assemblyLocation);
                ManagedInstallerClass.InstallHelper(
                    new[] { "/u", assemblyLocation } );
                Logger.Debug("Assembly uninstalled");
            }
            catch(Exception e)
            {
                Logger.Error("Service un-installation failed. Exception: " + e);
                return false;
            }
            return true;
        }
    }
}
